--Initial campaign triggers (static file, not updated)
--Copied to Status/camp_triggers.lua in first mission and subsequently read and updated there
--Campaign triggers are defined with conditions and actions
-------------------------------------------------------------------------------------------------------

--List of Return functions to build conditions:
--Return.Time()												returns time of day in seconds
--Return.Day()												returns day of month
--Return.Month()											returns month as number
--Return.Year()												returns year as number
--Return.Mission()											returns campaign mission number
--Return.CampFlag(flag-n)									returns value of campaign flag
--Return.AirUnitActive("UnitName")							returned boolean whether the air unit is active			
--Return.AirUnitReady("UnitName")							returns amount of ready aircraft in unit
--Return.AirUnitAlive("UnitName")							returns amount of ready and damaged aircraft in unit
--Return.AirUnitBase("UnitName")							returns the name of the airbase the unit operats from
--Return.AirUnitPlayer("UnitName")							returns boolean whether the air units is playable
--Return.TargetAlive("TargetName")							returns percentage of alive sub elements in target
--Return.UnitDead(unitname)									(ADD) return vehicle/ship units dead (ADD)
--Return.GroupHidden("GroupName")							returns group hidden status
--Return.GroupProbability("GroupName")						returns group spawn probability value between 0 and 1
--Return.ShipGroupInPoly(GroupName, PolyZonesTable)			(ADD) return boolean whether ship group is in polygon (ADD)

--List of Action functions for trigger actions:
--Action.None()
--Action.Text("your briefing text")
--Action.TextPlayMission(arg)																--add trigger text to briefing text of this mission only if it is playable
--Action.SetCampFlag(flag-n, boolean/number)												--
--Action.AddCampFlag(flag-n, number)														--
--Action.AddImage("filname.jpg")															--
--Action.CampaignEnd("win"/"draw"/"loss")													--
--Action.TargetActive("TargetName", boolean)												--
--Action.AirUnitActive("UnitName", boolean)													--
--Action.AirUnitBase("UnitName", "BaseName")												--
--Action.AirUnitPlayer("UnitName", boolean)													--
--Action.AirUnitReinforce("SourceUnitName", "DestinationUnitName", destNumber)				--
--Action.AirUnitRepair()																	--
--Action.GroundUnitRepair()																	-- (ADD) M19.f : Repair Ground
--Action.AddGroundTargetIntel("sideName")													--
--Action.GroupHidden("GroupName", boolean)													--
--Action.GroupProbability("GroupName", number 0-1)											--
--Action.GroupMove(GroupName, ZoneName)														-- (ADD) move vehicle group to refpoint (See the DC_CheckTriggers.lua file for more explanation)
--Action.GroupSlave(GroupName, master, bearing, distance)									-- (ADD)
--Action.ShipMission(GroupName, WPtable, CruiseSpeed, PatrolSpeed, StartTime)				-- (ADD) assign and run a movement mission to a ship group (See the DC_CheckTriggers.lua file for more explanation)
--Action.TemplateActive(TabFile)															-- (ADD) M40 : Template Active GroundGroup moving front (single file : active template) (if tab file: random activation)



--Important notes:
--for condition and action strings: outside with single quotes '', inside with double quotes ""!

camp_triggers = {
	
	----- CAMPAIGN INTRO ----
	["Campaign Briefing"] = {										--Trigger name
		active = true,												--Trigger is active
		once = true,												--Trigger is fired once
		condition = 'true',											--Condition of the trigger to return true or false embedded as string
		action = {													--Trigger action function embedded as string
			[1] = 'Action.Text("Iran is becoming more and more aggressive in Persian Gulf. Iranian s islands are more and more fortified and soon it will become very dangerous for any ship trying to cross the Gulf. South gulf countries asked US forces to prevent a complete blocade of this area.")',
			[2] = 'Action.Text("The US Air Force has sent considerable forces to UEA in support of the operation. At the forefront are the F-15C Eagles of the 58th Tactical Fighter Squadron who are tasked to attain air superiority and protect coalition strike aircraft against the Iranian Air Force helped by the 1/12 Cambresis and the VF-101 with its mythic Tomcat. Exceptionaly the sweden sent F7 squadron with AJS-37 Viggen to attack ships and ground targets. The brunt of daylight attack falls on the F-16C of the 17th and 13th Tactical Fighter Squadrons, supported by F/A-18C of the VFA-106. VMA-311 is deployed on LHA Tarawa to conduct air to ground missions. Attack during the night is carried out by the F-15E Strike Eagles of the 335th Tactical Fighter Squadron, who are looking forward to the types combat debut. Of considerable interest to the USAF is the deployment of the F-117A Nighthawk stealth bomber with the 417th Tactical Fighter Squadron. The USAF contingent is completed by a deployment of E-3A Sentry from the 7th Airborne Command and Control Squadron. Together these squadrons form a powerful and mighty force.")',
			[3] = 'Action.Text("The Iranian Air Force is flying a mix of MiG-29A, F-14A, F-4E and F-5E-3 fighters directed by ground based early warning radar. Air bases and target complexes of high value are protected by a variety of surface-air missile systems, such as the Hawk system, the SA-2, the SA-6 Gainful, the Rapier, as well as short-range IR-SAMs and AAA. As part of the coalition air offensive, the US Air Force is tasked with neutralizing the Iranian Air Force, both in the air and on the ground, as well as destroying Iranian airbases.")',
			[4] = 'Action.AddImage("Newspaper_FirstNight_blue.jpg", "blue")',
			[5] = 'Action.AddImage("Newspaper_FirstNight_red.jpg", "red")',
		},
	},
	
	
	----- CAMPAIGN END -----
	["Campaign End Victory 1"] = {
		active = true,
		once = false,
		condition = 'GroundTarget["blue"].percent < 45',
		action = {
			[1] = 'Action.CampaignEnd("win")',
			[2] = 'Action.Text("The Allied units deployed to UEA have successfully destroyed all the targets that they were assigned by US Central Command with the precious help of the French fighters and Sweden Viggen. With the complete destruction of the Iranian airbases, the air campaign of this war comes to an end. Allied air power has once again proven its effectiveness and decisiveness. Well done.")',
			[3] = 'Action.AddImage("Newspaper_Victory_blue.jpg", "blue")',
			[4] = 'Action.AddImage("Newspaper_Defeat_red.jpg", "red")',
			[5] = 'NoMoreNewspaper = true',
		},
	},
	["Campaign End Victory 2"] = {
		active = true,
		once = true,
		condition = 'Return.AirUnitReady("81 TFS") + Return.AirUnitReady("23 TFS") + Return.AirUnitReady("91 TFS") + Return.AirUnitReady("41 TFS") + Return.AirUnitReady("72 TFS") + Return.AirUnitReady("51 TFS") + Return.AirUnitReady("21 TFS") + Return.AirUnitReady("83 TFS") + Return.AirUnitReady("21-2 TFS") < 4',
		action = {
			[1] = 'Action.CampaignEnd("win")',
			[2] = 'Action.Text("The Islamic Republic Iranian Air Force is in ruins. After repeated air strikes and disastrous losses in air-air combat, the Iranians are no longer able to produce any sorties or offer any resistance. The NATO now owns complete air superiority. Well done.")',
			[3] = 'Action.AddImage("Newspaper_Victory_blue.jpg", "blue")',
			[4] = 'Action.AddImage("Newspaper_Defeat_red.jpg", "red")',
			[5] = 'NoMoreNewspaper = true',
		},
	},
	["Campaign End Victory 3"] = {
		active = true,
		once = false,
		condition = 'Return.TargetAlive("Lar Airbase") < 4 and Return.TargetAlive("Lar Airbase Strategics") < 4 and Return.TargetAlive("Abu Musa Island Airport") < 2 and Return.TargetAlive("Abu Musa Island Airport Strategics") < 4 and Return.TargetAlive("Sirri Island") < 3 and Return.TargetAlive("Sirri Island Airport Strategics") < 3 and Return.TargetAlive("Havadarya") < 4 and Return.TargetAlive("Havadarya Airport Strategics") < 7 and Return.TargetAlive("Bandar Abbas Intl") < 6 and Return.TargetAlive("Bandar Abbas Intl Strategics") < 14',
		action = {
			[1] = 'Action.CampaignEnd("win")',
			[2] = 'Action.Text("The Iranian Air Force is in ruins. All their bases are destroyed, Iran are no longer able to produce any sorties or offer any resistance. The Allied forces now owns complete air superiority. Well done.")',
			[3] = 'Action.AddImage("Newspaper_Victory_blue.jpg", "blue")',
			[4] = 'Action.AddImage("Newspaper_Defeat_red.jpg", "red")',
			[5] = 'NoMoreNewspaper = true',
		},
	},
	["Campaign End Loss"] = {
		active = true,
		once = false,
		condition = 'Return.AirUnitAlive("VFA-106") + Return.AirUnitReady("R/VFA-106") < 5',
		action = {
			[1] = 'Action.CampaignEnd("loss")',
			[2] = 'Action.Text("Ongoing combat operations have exhausted VFA-106. Loss rate has reached a level where reinforcements are no longer able to sustain combat operations. With the failure of Allied Air Force to attain air superiority, US Central Command has decided to call of the air campaign against the Iranians. Without destroying Iranians airbases it seems unlikely that the coalition will be able to win this war.")',
			[3] = 'Action.AddImage("Newspaper_Victory_red.jpg", "red")',
			[4] = 'Action.AddImage("Newspaper_Defeat_blue.jpg", "blue")',
			[5] = 'NoMoreNewspaper = true',
		},
	},
	["Campaign End Loss 2"] = {
		active = true,
		once = false,
		condition = 'Return.TargetAlive("CVN-71 Theodore Roosevelt") == 0',
		action = {
			[1] = 'Action.CampaignEnd("loss")',
			[2] = 'Action.Text("After the CVN-71 Theodore Roosevelt has been hit by air strikes and sunk, VFA-106 is no longer able to fly. Most of its planes are deep into the Caucasian waters and it will need a long time to restore this unit s capabilities. Other US units will have to continue the fight without the VFA-106 support. This is a bitter failure for the Navy")',
			[3] = 'Action.AddImage("Newspaper_Victory_red.jpg", "red")',
			[4] = 'Action.AddImage("Newspaper_Defeat_blue.jpg", "blue")',
			[5] = 'NoMoreNewspaper = true',
		},
	},
	["Campaign End Loss 3"] = {
		active = true,
		once = false,
		condition = 'GroundTarget["red"].percent < 20',
		action = {
			[1] = 'Action.CampaignEnd("loss")',
			[2] = 'Action.Text("Iranian airforce was able to destroy enough allied forces to decide US Command to ask for a cease fire  and stop any Air missions. This is a bitter failure for the Navy")',
			[3] = 'Action.AddImage("Newspaper_Victory_red.jpg", "red")',
			[4] = 'Action.AddImage("Newspaper_Defeat_blue.jpg", "blue")',
			[5] = 'NoMoreNewspaper = true',
		},
	},
	["Campaign End Draw"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() >= 50',
		action = {
			[1] = 'Action.CampaignEnd("draw")',
			[2] = 'Action.Text("The air campaign has seen a sustained period of inactivity. Seemingly unable to complete the destruction of the Islamic Republic Iranian Air Force and infrastructure, US Central Command has called off all squadrons from offensive operations. We hope negociations with Iranian will convince them to stop fortifications in the Persian Gulf")',
			[3] = 'NoMoreNewspaper = true',
		},
	},
	
	["CVN-74 John C. Stennis Sunk"] = {
		active = true,
		once = true,
		condition = 'Return.UnitDead("CVN-74 John C. Stennis")',
		action = {
			[1] = 'db_airbases["CVN-74 John C. Stennis"].inactive = true',
			[2] = 'Action.Text("CVN-74 John C. Stennis has been lost, the exact cause of her sinking is still somewhat unclear at the moment. Despite her evacuation being orderly and escorts of the Battle Group picking up many survivors, losses are expected to be very high. Search and rescue operations are still ongoing. All squadron aboard are not able to fight anymore. It s a difficult time for the US Navy.")',
			-- [3] = 'Action.AddImage("Newspaper_Victory_red.jpg", "red")',
			-- [4] = 'Action.AddImage("Newspaper_Defeat_blue.jpg", "blue")',
			-- [5] = 'NoMoreNewspaper = true',
		}	
	},
	["LHA_Tarawa Sunk"] = {
		active = true,
		once = true,
		condition = 'Return.UnitDead("LHA_Tarawa")',
		action = {
			[1] = 'db_airbases["LHA_Tarawa"].inactive = true',
			[2] = 'Action.Text("LHA_Tarawa has been lost, the exact cause of her sinking is still somewhat unclear at the moment. Despite her evacuation being orderly and escorts of the Battle Group picking up many survivors, losses are expected to be very high. Search and rescue operations are still ongoing. It s a difficult time for the US Navy.")',
			-- [3] = 'Action.AddImage("Newspaper_Victory_red.jpg", "red")',
			-- [4] = 'Action.AddImage("Newspaper_Defeat_blue.jpg", "blue")',
			-- [5] = 'NoMoreNewspaper = true',
		}	
	},
	
	----- CARRIER MOVEMENT -----
	["TF-74 Patrol ATest Sea"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() == 1',
		action = 'Action.ShipMission("TF-74", {{"Indy 1-1", "Indy 1-2", "Indy 1-3", "Indy 1-4"}}, 10, 8, nil)',
	},
	["TF-71 Patrol ATest Sea"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() == 1',
		action = 'Action.ShipMission("TF-71", {{"Indy 2-1", "Indy 2-2", "Indy 2-3", "Indy 2-4"}}, 10, 8, nil)',
	},	
	["LHA-Group Patrol ATest Sea"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() == 1',
		action = 'Action.ShipMission("LHA-Group", {{"Indy 3-1", "Indy 3-2", "Indy 3-3", "Indy 3-4"}}, 10, 8, nil)',
	},
	
	----- CONVOY MOVEMENT -----
	["Civil Convoy Escorted 1 Patrol ATest Sea"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() == 1',
		action = 'Action.ShipMission("Civil Convoy Escorted 1", {{"Civil Convoy Escorted 1-1", "Civil Convoy Escorted 1-2", "Civil Convoy Escorted 1-3", "Civil Convoy Escorted 1-4"}}, 8, 5, nil)',
	},
	["Civil Convoy Escorted 2 Patrol ATest Sea"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() == 1',
		action = 'Action.ShipMission("Civil Convoy Escorted 2", {{"Civil Convoy Escorted 2-1", "Civil Convoy Escorted 2-2", "Civil Convoy Escorted 2-3", "Civil Convoy Escorted 2-4"}}, 8, 5, nil)',
	},
	["Civil Convoy Unescorted 1 Patrol ATest Sea"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() == 1',
		action = 'Action.ShipMission("Civil Convoy Unescorted 1", {{"CCU 1-1", "CCU 1-2", "CCU 1-3", "CCU 1-4"}}, 8, 5, nil)',
	},
	["Civil Convoy Unescorted 2 Patrol ATest Sea"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() == 1',
		action = 'Action.ShipMission("Civil Convoy Unescorted 2", {{"CCU 2-1", "CCU 2-2", "CCU 2-3", "CCU 2-4"}}, 8, 5, nil)',
	},
	["Cargo convoy 1 Patrol ATest Sea"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() == 1',
		action = 'Action.ShipMission("Cargo convoy 1", {{"Cargo 1-1", "Cargo 1-2", "Cargo 1-3"}}, 8, 5, nil)',
	},
	["Cargo convoy 2 Patrol ATest Sea"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() == 1',
		action = 'Action.ShipMission("Cargo convoy 2", {{"Cargo 2-1", "Cargo 2-2", "Cargo 2-3"}}, 8, 5, nil)',
	},
	["FFG Neutrashimy Patrol ATest Sea"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() == 1',
		action = 'Action.ShipMission("FFG Neutrashimy", {{"DD 1-1", "DD 1-2", "DD 1-3", "DD 1-4"}}, 14, 10, nil)',
	},
	["Molnya Patrol 1 Patrol ATest Sea"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() == 1',
		action = 'Action.ShipMission("Molnya Patrol 1", {{"Molnya 1-1", "Molnya 1-2", "Molnya 1-3"}}, 11, 8, nil)',
	},
	["Molnya Patrol 2 Patrol ATest Sea"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() == 1',
		action = 'Action.ShipMission("Molnya Patrol 2", {{"Molnya 2-1", "Molnya 2-2", "Molnya 2-3"}}, 11, 8, nil)',
	},
	["Molnya Patrol 3 Patrol ATest Sea"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() == 1',
		action = 'Action.ShipMission("Molnya Patrol 3", {{"Molnya 3-1", "Molnya 3-2", "Molnya 3-3"}}, 11, 8, nil)',
	},	

----- CAMPAIGN SITUATION -----
	["Campaign first destructions"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["blue"].percent < 100',
		action = {
			[1] = 'Action.Text("First targets have been destroyed. Keep up the good work")',
		},
	},
	["Campaign 20 percents destructions"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["blue"].percent < 80',
		action = {
			[1] = 'Action.Text("Enemy targets have sustained fair damages. Keep up the good work")',
		},
	},
	["Campaign 40 percents destructions"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["blue"].percent < 60',
		action = {
			[1] = 'Action.Text("Enemy targets have sustained great damages. Strike missions are really efficient and we will win this war soon")',
		},
	},
	["Campaign 50 percents destructions"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["blue"].percent < 50',
		action = {
			[1] = 'Action.Text("More than half of our targets are neutralized. Intelligence think that the enemy will ask for a cease fire soon")',
		},
	},
	----- AIRBASE STRIKES -----
	["Lar Airbase Disabled"] = {
		active = true,
		condition = 'Return.TargetAlive("Lar Airbase") < 4 and Return.TargetAlive("Lar Airbase Strategics") < 4',
		action = {
			[1] = 'db_airbases["Lar Airbase"].inactive = true',
			[2] = 'Action.Text("After the facilities at Lar Airbase have been hit by air strikes, air operations at this base came to a complete stop. Intelligence believes that due to the heavy damage inflicted, the base is no longer able to produce any aviation sorties.")',			
		}
	},
	["Abu Musa Island Airport Disabled"] = {
		active = true,
		condition = 'Return.TargetAlive("Abu Musa Island Airport") < 2 and Return.TargetAlive("Abu Musa Island Airport Strategics") < 4',
		action = {
			[1] = 'db_airbases["Abu Musa Island Airport"].inactive = true',
			[2] = 'Action.Text("After the facilities at Abu Musa Island Airport have been hit by air strikes, air operations at this base came to a complete stop. Intelligence believes that due to the heavy damage inflicted, the base is no longer able to produce any aviation sorties.")',			
		}
	},	
	["Sirri Island Disabled"] = {
		active = true,
		condition = 'Return.TargetAlive("Sirri Island") < 3 and Return.TargetAlive("Sirri Island Airport Strategics") < 3',
		action = {
			[1] = 'db_airbases["Sirri Island"].inactive = true',
			[2] = 'Action.Text("After the facilities at Sirri Island Airport have been hit by air strikes, air operations at this base came to a complete stop. Intelligence believes that due to the heavy damage inflicted, the base is no longer able to produce any aviation sorties.")',			
		}
	},
	["Havadarya Airport Disabled"] = {
		active = true,
		condition = 'Return.TargetAlive("Havadarya") < 4 and Return.TargetAlive("Havadarya Airport Strategics") < 7',
		action = {
			[1] = 'db_airbases["Havadarya"].inactive = true',
			[2] = 'Action.Text("After the facilities at Havadarya Airport have been hit by air strikes, air operations at this base came to a complete stop. Intelligence believes that due to the heavy damage inflicted, the base is no longer able to produce any aviation sorties.")',			
		}
	},	
	-- ["Qeshm Island Disabled"] = {
		-- active = true,
		-- condition = 'Return.TargetAlive("Qeshm Island") == 0',
		-- action = {
			-- [1] = 'db_airbases["Qeshm Island"].inactive = true',
		-- }
	-- },	
	["Bandar Abbas Intl Disabled"] = {
		active = true,
		once = false,
		condition = 'Return.TargetAlive("Bandar Abbas Intl") < 6 and Return.TargetAlive("Bandar Abbas Intl Strategics") < 14',
		action = {
			[1] = 'db_airbases["Bandar Abbas Intl"].inactive = true',
			[2] = 'Action.Text("After the facilities at Bandar Abbas Intl have been hit by air strikes, air operations at this base came to a complete stop. Intelligence believes that due to the heavy damage inflicted, the base is no longer able to produce any aviation sorties.")',
			[3] = 'Action.AddImage("Bandar Abbas.jpg", "blue")',
		}
	},
	
	
	----- RED CAP -----
	["CAP After EWR Destroyed"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("EWR 1 131") == 0 and Return.TargetAlive("EWR 2 132") == 0 and Return.TargetAlive("EWR 3 133") == 0',
		action = {
			[1] = 'Action.TargetActive("CAP Qeshm", true)',
			[2] = 'Action.TargetActive("CAP Islands", true)',
			[3] = 'Action.TargetActive("Lar Airbase Alert", false)',
			[4] = 'Action.TargetActive("Shiraz Intl Alert", false)',
			[5] = 'Action.TargetActive("Sirri Island Alert", false)',
			[6] = 'Action.TargetActive("Qeshm Island Alert", false)',
			[7] = 'Action.TargetActive("Bandar Abbas Intl Alert", false)',
			[8] = 'Action.TargetActive("Bandar Abbas Intl 100 Km Alert", false)',
			[9] = 'Action.TargetActive("CAP Bandar Abbas", true)',
			[10] = 'Action.Text("With the recent destruction of all Early Warning Radar sites in the operations area, the ability of the enemy to launch interceptors against our strike packages was severely degraded. Intelligence expects that the enemy will increasingly depend on Combat Air Patrols to compensate, though without the support of ground controllers these are estimated to be of limited effectiveness.")',
		},
	},		
	
	----- REPAIR AND REINFORCEMENTS -----
	["GroundUnitRepair"] = {
		active = true,
		condition = 'true',
		action = 'Action.GroundUnitRepair()',
	},
	["Repair"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitRepair()',
	},
	["Reinforce F7"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("F21", "F7", 8)',
	},	
	["Reinforce VMA 311"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("VMA 331", "VMA 311", 4)',
	},
	["Reinforce VAW-125"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/VAW-125", "VAW-125", 8)',
	},	
	["Reinforce EC 1/12"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("EC 2/12", "EC 1/12", 8)',
	},	
	["Reinforce 58 TFS"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/58 TFS", "58 TFS", 8)',
	},
	["Reinforce 335 TFS"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/335 TFS", "335 TFS", 6)',
	},
	["Reinforce 17 TFS"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/17 TFS", "17 TFS", 8)',
	},
	["Reinforce 13 TFS"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/13 TFS", "13 TFS", 8)',
	},
	["Reinforce 171 ARW"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/171 ARW", "171 ARW", 3)',
	},
	["Reinforce 174 ARW"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/174 ARW", "174 ARW", 4)',
	},
	-- ["Reinforce 41 TAS"] = {
		-- active = true,
		-- condition = 'true',
		-- action = 'Action.AirUnitReinforce("R/41 TAS", "41 TAS", 1)',
	-- },	
	["Reinforce VFA-106"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/VFA-106", "VFA-106", 16)',
	},
	-- ["Reinforce VFA-192"] = {
		-- active = true,
		-- condition = 'true',
		-- action = 'Action.AirUnitReinforce("R/VFA-192", "VFA-192", 16)',
	-- },	
	["Reinforce VF-101"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/VF-101", "VF-101", 16)',
	},
	-- ["Reinforce VF-32"] = {
		-- active = true,
		-- condition = 'true',
		-- action = 'Action.AirUnitReinforce("R/VF-32", "VF-32", 16)',
	-- },	
	["Reinforce 81 TFS"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("82 TFS", "81 TFS", 4)',
	},
	["Reinforce 23 TFS"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("11 TFS", "23 TFS", 4)',
	},
	["Reinforce 91 TFS"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("31 TFS", "91 TFS", 4)',
	},
	["Reinforce 41 TFS"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("141 TFS", "41 TFS", 4)',
	},
	["Reinforce 72 TFS"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("73 TFS", "72 TFS", 6)',
	},
	["Reinforce 51 TFS"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("52 TFS", "51 TFS", 4)',
	},
--[[	["Reinforce 53 TFS"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("54 TFS", "53 TFS", 4)',
	},]]--
	["Reinforce 21 TFS"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("22 TFS", "21 TFS", 4)',
	},
	["Reinforce 21-2 TFS"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("22-2 TFS", "21-2 TFS", 4)',
	},
--[[	["Reinforce 71 TAS"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/71 TAS", "71 TAS", 1)',
	},	
	["Reinforce 23 TFS"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("24 TFS", "23 TFS", 2)',
	},]]--
	["Reinforce 83 TFS"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("84 TFS", "83 TFS", 4)',
	},	
	

	----- AVIATION UNIT STATUS -----
	["VFA-106 Alive 75%"] = {
		active = true,
		once = true,
		condition = 'Return.AirUnitAlive("VFA-106") + Return.AirUnitReady("R/VFA-106") < 12',
		action = 'Action.Text("Aircraft strength of the VFA-106 equiped with Hornet has fallen below 75%.")',
	},
	["VFA-106 Alive 50%"] = {
		active = true,
		once = true,
		condition = 'Return.AirUnitAlive("VFA-106") + Return.AirUnitReady("R/VFA-106") < 8',
		action = 'Action.Text("Aircraft strength of the VFA-106 equiped with Hornet has fallen below 50%. If losses continue at the present rate, the combat capability of the squadron is in jeopardy.")',
	},
	["VFA-106 Alive 25%"] = {
		active = true,
		once = true,
		condition = 'Return.AirUnitAlive("VFA-106") + Return.AirUnitReady("R/VFA-106") < 6',
		action = 'Action.Text("Aircraft strength of the VFA-106 equiped with Hornet has fallen below 25%. The number of available airframes is critically low. The squadron is short of destruction.")',
	},
	["Newspaper Nighthawk Down"] = {
		active = true,
		once = true,
		condition = 'Return.AirUnitAlive("417 TFS") < 4',
		action = {
			[1] = 'Action.AddImage("Newspaper_NighthawkDown.jpg", "blue")',
			[2] = 'NoMoreNewspaper = true',
		},
	},
	
	
	---- GROUND TARGET STATUS ---
	["Blue Ground Target Briefing Intel"] = {
		active = true,
		condition = 'true',
		action = 'Action.AddGroundTargetIntel("blue")',
	},
	["Red Ground Target Briefing Intel"] = {
		active = true,
		condition = 'true',
		action = 'Action.AddGroundTargetIntel("red")',
	},
}